<div class="row g-3">

  <!-- Sección Datos Básicos -->
  <div class="col-12">
    <div class="card mb-3">
      <div class="card-header bg-primary text-white">
        Datos Básicos
      </div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-md-3">
            <label>Título</label>
            <input type="text" name="titulo" class="form-control" required>
          </div>
          <div class="col-md-3">
            <label>Fecha Publicación</label>
            <input type="date" name="fecha_publicacion" class="form-control" required>
          </div>
          <div class="col-md-3">
            <label>Fecha Límite</label>
            <input type="date" name="fecha_limite" class="form-control" required>
          </div>
          <div class="col-md-3">
            <label>Tipo Contrato</label>
            <select name="id_tipo_contrato" class="form-select" required>
              <option value="">Seleccione</option>
              <?php $__currentLoopData = $tipos_contrato; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($tipo->id_tipo_contrato); ?>"><?php echo e($tipo->nombre_tipo_contrato); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>

          <div class="col-md-3">
            <label>Empresa</label>
            <select name="id_empresa" class="form-select" required>
              <option value="">Seleccione</option>
              <?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($empresa->id_empresa); ?>"><?php echo e($empresa->nombre_empresa); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
          <div class="col-md-3">
            <label>Plan de Estudio</label>
            <select name="id_plan_estudio" class="form-select" required>
              <option value="">Seleccione</option>
              <?php $__currentLoopData = $planes_estudio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->nombre); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
          <div class="col-md-3">
            <label>Lugar</label>
            <input type="text" name="lugar" class="form-control" required>
          </div>
          <div class="col-md-3">
            <label>Tipo de Oferta</label>
            <input type="text" name="tipo_oferta" class="form-control">
          </div>

          <div class="col-md-3">
            <label>Remuneración</label>
            <input type="number" step="0.01" name="remuneracion" class="form-control">
          </div>
          <div class="col-md-3">
            <label>Vacantes</label>
            <input type="text" name="vacantes" class="form-control">
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Sección Descripción y Requisitos -->
  <div class="col-12">
    <div class="card mb-3">
      <div class="card-header bg-secondary text-white">
        Descripción y Requisitos
      </div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-md-12">
            <label>Descripción</label>
            <textarea name="descripcion" class="form-control" rows="3" required></textarea>
          </div>
          <div class="col-md-6">
            <label>Experiencia</label>
            <textarea name="experiencia" class="form-control" rows="2"></textarea>
          </div>
          <div class="col-md-6">
            <label>Pasos para postular</label>
            <textarea name="pasos_postular" class="form-control" rows="2"></textarea>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Sección Archivos y Estado -->
  <div class="col-12">
    <div class="card mb-3">
      <div class="card-header bg-info text-white">
        Archivos y Estado
      </div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-md-6">
            <label>Archivo PDF (opcional)</label>
            <input type="file" name="archivo_pdf" class="form-control" accept="application/pdf">
          </div>
          <div class="col-md-6">
            <label>Estado</label>
            <select name="estado" class="form-select" required>
              <option value="aceptado">Aceptado</option>
              <option value="pendiente">Pendiente</option>
              <option value="rechazado">Rechazado</option>
            </select>
          </div>
        </div>
      </div>
    </div>
  </div>

</div>
<?php /**PATH /home/dedu/public_html/iestpdv.dedu.pe/resources/views/ofertas_laborales/partials/form.blade.php ENDPATH**/ ?>