<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Semestres <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalNuevoPeriodo">
                    <i class="fas fa-plus"></i> Agregar Nuevo Semestre
                </button>
                <div class="table-responsive">
                    <table id="tablaSemestres" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Descripción</th>
                                <th>Estado</th>
                                <th>Fecha Creación</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $semestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($semestre->id); ?></td>
                                    <td><?php echo e($semestre->nombre); ?></td>
                                    <td><?php echo e($semestre->descripcion); ?></td>
                                    <td>
                                        <?php if($semestre->activo): ?>
                                            <span class="badge badge-soft-success">Activo</span>
                                        <?php else: ?>
                                            <span class="badge badge-soft-warning">Inactivo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($semestre->created_at->format('Y-m-d H:i')); ?></td>
                                    <td>
                                        <!-- Icono de editar -->
                                        <a href="#"
                                            class="text-warning"
                                            data-bs-toggle="modal"
                                            data-bs-target="#editModal"
                                            data-id="<?php echo e($semestre->id); ?>"
                                            data-nombre="<?php echo e($semestre->nombre); ?>"
                                            data-descripcion="<?php echo e($semestre->descripcion); ?>"
                                            data-activo="<?php echo e($semestre->activo); ?>">
                                            <i class="las la-pen text-secondary font-18"></i>
                                        </a>

                                        <!-- Icono de eliminar -->
                                        <a href="#" 
                                            class="text-danger btn-eliminar-semestre" 
                                            data-id="<?php echo e($semestre->id); ?>">
                                                <i class="las la-trash-alt text-secondary font-18"></i>
                                        </a>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>


                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->
<!-- Modal: Nuevo Semestre -->
<div class="modal fade" id="modalNuevoPeriodo" tabindex="-1" aria-labelledby="modalNuevoPeriodoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form action="<?php echo e(route('semestres.store')); ?>" method="POST" id="formNuevoSemestre">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalNuevoPeriodoLabel">
                        <i class="fas fa-plus-circle text-primary"></i> Nuevo Semestre
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <!-- Nombre -->
                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="nombre" name="nombre" required>
                    </div>

                    <!-- Descripción -->
                    <div class="mb-3">
                        <label for="descripcion" class="form-label">Descripción</label>
                        <textarea class="form-control" id="descripcion" name="descripcion" rows="3"></textarea>
                    </div>

                    <!-- Estado -->
                    <div class="mb-3">
                        <label for="activo" class="form-label">Estado</label>
                        <select class="form-select" id="activo" name="activo">
                            <option value="1" selected>Activo</option>
                            <option value="0">Inactivo</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-de-primary">Guardar</button>
                </div>
            </div>
        </form>
    </div>
</div>




<!-- Modal de Edición -->

<!-- Modal: Editar Semestre -->
<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="formEditarSemestre" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-edit text-warning"></i> Editar Semestre</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <!-- Campo oculto para ID -->
                    <input type="hidden" id="edit_id">

                    <!-- Nombre -->
                    <div class="mb-3">
                        <label for="edit_nombre" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="edit_nombre" name="nombre" required>
                    </div>

                    <!-- Descripción -->
                    <div class="mb-3">
                        <label for="edit_descripcion" class="form-label">Descripción</label>
                        <textarea class="form-control" id="edit_descripcion" name="descripcion" rows="3"></textarea>
                    </div>

                    <!-- Estado -->
                    <div class="mb-3">
                        <label for="edit_activo" class="form-label">Estado</label>
                        <select class="form-select" id="edit_activo" name="activo">
                            <option value="1">Activo</option>
                            <option value="0">Inactivo</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-de-warning">Actualizar</button>
                </div>
            </div>
        </form>
    </div>
</div>




<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaSemestres").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaSemestres_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
    $(document).ready(function () {
        $('#formNuevoSemestre').submit(function (e) {
            e.preventDefault();

            let form = $(this);
            let url = form.attr('action');
            let data = form.serialize();

            $.ajax({
                type: "POST",
                url: url,
                data: data,
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: '¡Registrado!',
                        text: 'El semestre fue registrado correctamente.',
                        timer: 2000,
                        showConfirmButton: false
                    });

                    // Cierra el modal
                    $('#modalNuevoPeriodo').modal('hide');

                    // Limpia el formulario
                    form[0].reset();

                    // Puedes hacer reload parcial o full según tu necesidad
                    setTimeout(() => location.reload(), 2000); // o actualizar solo la tabla vía AJAX
                },
                error: function (xhr) {
                    let errores = xhr.responseJSON.errors;
                    let mensaje = 'Hubo un error al registrar el semestre.';

                    if (errores) {
                        mensaje = Object.values(errores).join('<br>');
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: mensaje
                    });
                }
            });
        });
    });
</script>

<script>
    $(document).ready(function () {
        // Cuando se abre el modal de editar, cargar los datos
        $('#editModal').on('show.bs.modal', function (event) {
            const button = $(event.relatedTarget);
            const id = button.data('id');
            const nombre = button.data('nombre');
            const descripcion = button.data('descripcion');
            const activo = button.data('activo');

            $('#edit_id').val(id);
            $('#edit_nombre').val(nombre);
            $('#edit_descripcion').val(descripcion);
            $('#edit_activo').val(activo);
        });

        // Enviar formulario por AJAX
        $('#formEditarSemestre').submit(function (e) {
            e.preventDefault();

            const id = $('#edit_id').val();
            const url = `/semestres/${id}`;
            const data = {
                _token: $('input[name="_token"]').val(),
                _method: 'PUT',
                nombre: $('#edit_nombre').val(),
                descripcion: $('#edit_descripcion').val(),
                activo: $('#edit_activo').val(),
            };

            $.ajax({
                url: url,
                type: 'POST',
                data: data,
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: '¡Actualizado!',
                        text: 'El semestre se actualizó correctamente.',
                        timer: 2000,
                        showConfirmButton: false
                    });

                    $('#editModal').modal('hide');
                    setTimeout(() => location.reload(), 2000); // O actualiza la tabla con JS
                },
                error: function (xhr) {
                    let errores = xhr.responseJSON.errors;
                    let mensaje = 'Ocurrió un error al actualizar.';

                    if (errores) {
                        mensaje = Object.values(errores).join('<br>');
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: mensaje
                    });
                }
            });
        });
    });
</script>

<script>
$(document).ready(function () {
    $('.btn-eliminar-semestre').click(function (e) {
        e.preventDefault();
        let id = $(this).data('id');

        Swal.fire({
            title: '¿Estás seguro?',
            text: 'Esta acción no se puede deshacer.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `/semestres/${id}`,
                    type: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        _method: 'DELETE'
                    },
                    success: function (response) {
                        Swal.fire({
                            icon: 'success',
                            title: '¡Eliminado!',
                            text: 'El semestre fue eliminado correctamente.',
                            timer: 2000,
                            showConfirmButton: false
                        });

                        // Elimina la fila de la tabla
                        $(`a[data-id="${id}"]`).closest('tr').remove();
                    },
                    error: function () {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Hubo un problema al eliminar el semestre.'
                        });
                    }
                });
            }
        });
    });
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestpdv.dedu.pe/resources/views/semestres/index.blade.php ENDPATH**/ ?>