<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Registrar Estudiantes <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                <!-- Asegúrate de tener Bootstrap Icons en tu layout -->
                <form action="<?php echo e(route('estudiantes.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <!-- Sección 1: Datos Personales -->
                    <div class="card border-primary mb-4">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0 text-white">Datos Personales</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <label for="dni" class="form-label">DNI</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="bi bi-credit-card-2-front"></i></span>
                                        <input type="text" name="dni" class="form-control" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label for="nombres" class="form-label">Nombres</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="bi bi-person"></i></span>
                                        <input type="text" name="nombres" class="form-control" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label for="apellidos" class="form-label">Apellidos</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="bi bi-person-lines-fill"></i></span>
                                        <input type="text" name="apellidos" class="form-control" required>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <label for="email" class="form-label">Correo</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="bi bi-envelope"></i></span>
                                        <input type="email" name="email" class="form-control" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label for="telefono" class="form-label">Teléfono</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="bi bi-telephone"></i></span>
                                        <input type="text" name="telefono" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label for="fecha_nacimiento" class="form-label">Fecha de Nacimiento</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="bi bi-calendar-event"></i></span>
                                        <input type="date" name="fecha_nacimiento" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label for="genero" class="form-label">Género</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="las la-venus-mars"></i></span>
                                        <select name="genero" id="genero" class="form-select" required>
                                            <option value="">Seleccione</option>
                                            <option value="Masculino">Masculino</option>
                                            <option value="Femenino">Femenino</option>
                                            <option value="Otro">Otro</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label for="fuente_inscripcion" class="form-label">Fuente de Inscripción</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="las la-bullhorn"></i></span>
                                        <select name="fuente_inscripcion" id="fuente_inscripcion" class="form-select">
                                            <option value="">Seleccione</option>
                                            <option value="Redes Sociales">Redes Sociales</option>
                                            <option value="Radio">Radio</option>
                                            <option value="Amigos">Amigos</option>
                                            <option value="Televisión">Televisión</option>
                                        </select>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>

                    <!-- Sección 2: Información Académica -->
                    <div class="card border-success mb-4">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0 text-white">Información Académica</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label for="lengua_materna" class="form-label">Lengua Materna</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="bi bi-translate"></i></span>
                                        <input type="text" name="lengua_materna" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="año_egreso" class="form-label">Año de Egreso</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="bi bi-calendar-check"></i></span>
                                        <input type="text" name="año_egreso" class="form-control">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Sección 3: Discapacidad -->
                    <div class="card border-warning mb-4">
                        <div class="card-header bg-warning text-dark">
                            <h5 class="mb-0 text-white">Información de Discapacidad</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label for="discapacidad" class="form-label">¿Tiene discapacidad?</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="bi bi-universal-access"></i></span>
                                        <select name="discapacidad" class="form-select">
                                            <option value="">Seleccione</option>
                                            <option value="1">Sí</option>
                                            <option value="0">No</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="nombre_discapacidad" class="form-label">Tipo de Discapacidad</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="bi bi-info-circle"></i></span>
                                        <input type="text" name="nombre_discapacidad" class="form-control">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Sección 4: Archivos Adjuntos -->
                    <div class="card border-info mb-4">
                        <div class="card-header bg-info text-white">
                            <h5 class="mb-0 text-white">Archivos Adjuntos</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label for="foto_postulante" class="form-label">Foto del Postulante</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="bi bi-camera"></i></span>
                                        <input type="file" name="foto_postulante" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="certificado_estudios" class="form-label">Certificado de Estudios</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="bi bi-file-earmark-text"></i></span>
                                        <input type="file" name="certificado_estudios" class="form-control">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Botones -->
                    <div class="text-center">
                        <button type="submit" class="btn btn-primary px-4">Registrar</button>
                        <a href="<?php echo e(route('postulantess.index')); ?>" class="btn btn-secondary px-4">Cancelar</a>
                    </div>
                </form>


                        
                
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->









<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>



<script>
    $(document).ready(function () {
        $('form').on('submit', function (e) {
            e.preventDefault();

            let form = $(this)[0];
            let formData = new FormData(form);

            $.ajax({
                url: $(this).attr('action'),
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                beforeSend: function () {
                    Swal.fire({
                        title: 'Procesando...',
                        text: 'Por favor, espere',
                        allowOutsideClick: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });
                },
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Registro exitoso',
                        text: 'El postulante fue registrado correctamente',
                        confirmButtonText: 'Aceptar'
                    }).then(() => {
                        window.location.href = "<?php echo e(route('estudiantes.index')); ?>";
                    });
                },
                error: function (xhr) {
                    Swal.close(); // Cierra el loading

                    if (xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        let listaErrores = '';

                        $.each(errors, function (campo, mensajes) {
                            mensajes.forEach(function (mensaje) {
                                listaErrores += `• ${mensaje}<br>`;
                            });
                        });

                        Swal.fire({
                            icon: 'error',
                            title: 'Errores de validación',
                            html: listaErrores,
                            confirmButtonText: 'Corregir'
                        });
                    } else {
                        let mensaje = xhr.responseJSON?.message || 'Ocurrió un error inesperado.';
                        Swal.fire({
                            icon: 'error',
                            title: 'Error al registrar',
                            text: mensaje,
                            confirmButtonText: 'Cerrar'
                        });
                    }
                }
            });
        });
    });
</script>






<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestpdv.dedu.pe/resources/views/estudiantes/create.blade.php ENDPATH**/ ?>