<?php

namespace App\Http\Controllers;

use App\Models\TipoAdmision;
use Illuminate\Http\Request;

class TipoAdmisionController extends Controller
{
    public function index()
    {
        $tipos = TipoAdmision::all();
        return view('tipo_admision.index', compact('tipos'));
    }

    public function create()
    {
        return view('tipo_admision.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:50|unique:tipo_admision,nombre',
            'monto' => 'required|numeric|min:0',
            'monto_extemporaneo' => 'required|numeric|min:0',
            'activo' => 'required|boolean',
        ]);

        $tipo = TipoAdmision::create($request->all());

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Tipo de admisión registrado correctamente.',
                'data' => $tipo
            ]);
        }

        return redirect()->route('tipo_admision.index')->with('success', 'Tipo de admisión registrado correctamente.');
    }


    public function show($id)
    {
        $tipo = TipoAdmision::findOrFail($id);
        return view('tipo_admision.show', compact('tipo'));
    }

    public function edit($id)
    {
        $tipo = TipoAdmision::findOrFail($id);
        return view('tipo_admision.edit', compact('tipo'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'nombre' => 'required|string|max:50|unique:tipo_admision,nombre,' . $id . ',id_tipo_admision',
            'monto' => 'required|numeric|min:0',
            'monto_extemporaneo' => 'required|numeric|min:0',
            
        ]);

        $tipo = TipoAdmision::findOrFail($id);
        $tipo->update([
            'nombre' => $request->nombre,
            'monto' => $request->monto,
            'monto_extemporaneo' => $request->monto_extemporaneo,
            
        ]);

        if ($request->ajax()) {
            return response()->json(['success' => true, 'message' => 'Tipo de admisión actualizado correctamente.']);
        }

        return redirect()->route('tipo_admision.index')->with('success', 'Tipo de admisión actualizado correctamente.');
    }


    public function destroy($id)
{
    try {
        $tipo = TipoAdmision::findOrFail($id);
        $tipo->delete();

        return response()->json([
            'success' => true,
            'message' => 'Tipo de admisión eliminado correctamente.'
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => 'Ocurrió un error al eliminar el tipo de admisión.',
            'error' => $e->getMessage()
        ], 500);
    }
}


    // En TipoAdmisionController.php
    public function cambiarEstado(Request $request, $id)
    {
        $tipo = TipoAdmision::findOrFail($id);
        $tipo->activo = $request->activo;
        $tipo->save();

        return response()->json(['success' => true, 'message' => 'Estado actualizado correctamente.']);
    }

}
